import alice.tucson.api.*;
import alice.logictuple.*;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;

/*Thread che si occupa di osservare se qualche utente abbandona la chat
 *
 *@author Rossella Rubino
 *@version agosto1 2004 
 */
public class ObserverLeave extends Thread {
        
    	private TucsonContext context;
        private TupleCentreId chatId,quizId,chatIdR,quizIdR;
        
        public ObserverLeave(AgentId aid, TupleCentreId id, TupleCentreId qid, 
        TupleCentreId idr, TupleCentreId qidr) throws Exception {
            this.chatId=id;
            this.quizId=qid;
            this.chatIdR=idr;
            this.quizIdR=qidr;
            this.context = Tucson.enterContext(new DefaultContextDescription(aid));
        }

        public void run(){
            try {
            	while (true){          	       
        			LogicTuple temp=LogicTuple.parse("leave(_,_)");
        			
	        		LogicTuple lt;
	        		try{
	        			lt=context.in(chatId,temp);
	        		}
	        		catch(UnreachableNodeException une){}
	        		try{
	        			lt=context.in(chatIdR,temp);
	        		}
	        		catch(UnreachableNodeException une){
	        			lt=context.in(chatId,temp);
	        		}
	        		String luser=lt.getArg(0).toString();
	        		String hostUser=lt.getArg(1).toString();	        		
	        		
	        		/*l'utente viene cancellato dall'elenco degli utenti 
	        		partecipanti alla chat*/
	        		LogicTuple lut=LogicTuple.parse("user("+luser+",_)");
	        		try{
	        			context.in(chatId,lut); 
	        		 
	        		}
	        		catch(UnreachableNodeException une){}
	        		try{
	        			context.in(chatIdR,lut);
	        			  
	        		}
	        		catch(UnreachableNodeException une){}
	        		
	        		/*l'utente non partecipa al quiz*/
	        		LogicTuple luq=LogicTuple.parse("user("+luser+",_,_,_)");
	        		LogicTuple l;
	        		
	        		try{
	        			l=context.inp(quizId,luq); 
	        		}
	        		catch(UnreachableNodeException une){}	        		
	        		try{
	        			l=context.inp(quizIdR,luq);   
	        		}
	        		catch(UnreachableNodeException une){
	        			l=context.in(quizId,luq); 
	        		}
	        		if (l!=null){
	        			
	        			String score=luq.getArg(2).getArg(0).toString();	        		
	        			luq=LogicTuple.parse("user("+luser+",host("+hostUser+"),score("+score+"),status(offline))");
	        			try{
	        				context.out(quizId,luq);       
	        			}
	        			catch(UnreachableNodeException une){}
	        			try{
	        				context.out(quizIdR,luq);        		  	        
	        			}
	        			catch(UnreachableNodeException une){}
	        			
	        		}
	        		        			        		
	        		System.out.println(luser+" lascia la chat");
	        
	      		  	LogicTuple count=LogicTuple.parse("countUser(_)");
	        		LogicTuple numu;
	        		try{
	        			numu=context.in(chatId,count);
	        			
	        		}
	        		catch(UnreachableNodeException une){}
	        		
	        		try{
	        			numu=context.in(chatIdR,count);
	        			
	        		}
	        		catch(UnreachableNodeException une){
	        			numu=context.in(chatId,count);
	        		}
	        		int n=Integer.parseInt(numu.getArg(0).toString());
	        		LogicTuple addu=LogicTuple.parse("countUser("+(n-1)+")");
					try{
						context.out(chatId,addu);
					}
					catch(UnreachableNodeException une){}
					try{
						context.out(chatIdR,addu);
					}
					catch(UnreachableNodeException une){}
					
					      
	       			Var vt=new Var("Lista");
					LogicTuple tupletemplateEnv=LogicTuple.parse("user(_,_)");	        			
					LogicTuple tlist;
					Term t=null;
					try{
						tlist=context.in(chatId,new LogicTuple("rdall",new TupleArgument(tupletemplateEnv.toTerm()),vt));
						t=vt.toTerm();	
					}
					catch(UnreachableNodeException une){}
							
					Var vt2=new Var("Lista");					
					try{
						tlist=context.in(chatIdR,new LogicTuple("rdall",new TupleArgument(tupletemplateEnv.toTerm()),vt2));
						t=vt2.toTerm();	
					}
					catch(UnreachableNodeException une){}
					
					alice.tuprolog.Var head;									
					Struct lista = (Struct) t.getTerm();
								
					while (!lista.unify(new Struct())) {
						head = new alice.tuprolog.Var("Head");
						alice.tuprolog.Var tail = new alice.tuprolog.Var("Tail");
						boolean res = lista.unify(new Struct(head,tail));
						lista = (Struct) tail.getTerm();
					
						String tupla=head.toString();										
						LogicTuple ust=LogicTuple.parse(tupla);	
				
						String usr=ust.getArg(1).getArg(0).toString();
						
						TupleCentreId userTC=new TupleCentreId(usr.toLowerCase()+" @ "+hostUser);
            							
						context.out(userTC,temp);
					}			
					
	        	}
	     	}                
            catch (Exception ex){
                ex.printStackTrace();
            }
        }
	}